#ifndef _DEVUSERLOGIN_H_
#define _DEVUSERLOGIN_H_

#include "dllexport.h"

class CDevInfo;

typedef struct tagLOG_TIME
{
	DWORD    dwYear;
	DWORD    dwMonth;
	DWORD    dwDay;
	DWORD    dwHour;
	DWORD    dwMinute;
	DWORD    dwSecond;
} LOG_TIME;

typedef struct
{
	LOG_TIME     strLogTime;
	DWORD        dwMajorType;
	DWORD        dwMinorType;
	BYTE         sPanelUser[16];
	BYTE         sNetUser[16];
	char		 sIpV4[16];
	char         sIpV6[128];
	DWORD        dwParaType;
	DWORD        dwChannel;
	DWORD        dwDiskNumber;
	DWORD        dwAlarmInPort;
	DWORD        dwAlarmOutPort;
	DWORD        dwInfoLen;
	char         sInfo[4096];
} DEV_LOG;

typedef void(CALLBACK *fVoiceDataCallBack)(
    LONG lVoiceComHandle, 
    char *pRecvDataBuffer, 
    DWORD dwBufSize,
    BYTE byAudioFlag,
    void* pUser);

class IDevUserLogin
{
public:
	virtual int         GetManufactureID() = 0;
    virtual int         Login(void) = 0;
    virtual int         Logout(void) = 0;
    virtual bool        HasLogedin(void) = 0;
    virtual LONG        GetLoginId(BOOL bNeedLogin = TRUE) = 0;
    virtual bool        IsLoginIdValid(void) = 0;
    virtual char*       GetSerialNumber(void) = 0;
    virtual int         GetAlarmInportNum(void) = 0;
    virtual int         GetAlarmOutportNum(void) = 0;
    virtual int         GetDiskNum(void) = 0;
    virtual int         GetDvrType(void) = 0;
    virtual int         GetDvrSubType(void) = 0;
	virtual int			GetDvrVideoStandard(void) = 0;
	virtual int			GetHDChannels(unsigned int nHDChannels[4]) = 0;
	virtual char*		GetDvrTypeInfo(void) = 0;
    virtual int         GetChannelNum(void) = 0;
    virtual int         GetStartChannelNum(void) = 0;
    virtual bool        StartRecord(LONG lChannel, LONG lRecordType) = 0;
    virtual bool        StopRecord(LONG lChannel) = 0;
    virtual int         Reboot() = 0;
    virtual int         ShutDown() = 0;
    virtual int         GetUpgradeProgress() = 0;
    virtual int         GetUpgradeState() = 0;
	virtual bool        FindLog(LONG lSelectMode, DWORD dwMajorType, DWORD dwMinorType, LOG_TIME *lpStartTime, LOG_TIME *lpStopTime, BOOL bOnlySmart) = 0;        
	virtual bool        FindLogClose() = 0;
	virtual bool        FindNextLog(DEV_LOG *pLog) = 0;
    virtual BOOL        StartVoiceCom(DWORD dwVoiceChan,BOOL bNeedCBNoEncData,fVoiceDataCallBack cbVoiceDataCallBack,void *pUser) = 0;
    virtual BOOL        StopVoiceCom() = 0;
};


class DLLAPI CDevUserLoginFactory
{
public:
	static IDevUserLogin *CreateDevUserLogin(CDevInfo *devInfo);
	static void DeleteDevUserLogin(IDevUserLogin *pUser);
};

#endif
